/* Scene converter copy scripts to user folder at Max startup*/
/* If the folder already exists, don't copy the files again we may erase customized files*/

--check if the folder exists, if not, create it.
--folder should be sort of : "C:\Users\%USERNAME%\Autodesk\3ds Max %VERSION%\Scene Converter\"
(
	if false == maxops.isInSecureMode() do
	(
		local string_folder = sceneconverter.GetUserProfileFolder()
		local string_originalfolder = GetDir #maxroot + "SceneConverter"

		if  false == doesfileExist string_folder then
		(
			--This folder doesn't exist yet, create it
			HiddenDOSCommand ("mkdir \""+string_folder+"\"")

			--Copy the Scene converter files in that folder
			HiddenDOSCommand ("xcopy /E /Y \""+string_originalfolder+"\" \""+string_folder+"\"")
		)
		else
		(
			local cp_path = string_originalfolder + "\\ConversionPresets\\*.ms"
			local cp_files = getFiles cp_path

			for file in cp_files do
			(
				local file_name = fileNameFromPath file
				local target_name = string_folder + "ConversionPresets\\" + file_name
				
				if  false == doesfileExist target_name then
				(
					local cmd = "copy \""+file+"\" \""+target_name+"\""
					HiddenDOSCommand (cmd)
				)
			)
			
			local cs_path = string_originalfolder + "\\ConversionScripts\\*.ms"
			local cs_files = getFiles cs_path

			for file in cs_files do
			(
				local file_name = fileNameFromPath file
				local target_name = string_folder + "ConversionScripts\\" + file_name
				
				if  false == doesfileExist target_name then
				(
					local cmd = "copy \""+file+"\" \""+target_name+"\""
					HiddenDOSCommand (cmd)
				)
			)
		)
	)
)